# generated by datamodel-codegen:
#   filename:  dsse_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class ProposedContent(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    envelope: StrictStr = Field(
        ...,
        description="DSSE envelope specified as a stringified JSON object",
    )
    verifiers: List[str] = Field(
        ...,
        description="collection of all verification material (e.g. public keys or certificates) used to verify signatures over envelope's payload, specified as base64-encoded strings",
        min_length=1,
    )


class Signature(BaseModel):
    """a signature of the envelope's payload along with the verification material for the signature"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    signature: StrictStr = Field(..., description="base64 encoded signature of the payload")
    verifier: str = Field(
        ...,
        description="verification material that was used to verify the corresponding signature, specified as a base64 encoded string",
    )


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"


class EnvelopeHash(BaseModel):
    """Specifies the hash algorithm and value encompassing the entire envelope sent to Rekor"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(
        ...,
        description="The value of the computed digest over the entire envelope",
    )


class PayloadHash(BaseModel):
    """Specifies the hash algorithm and value covering the payload within the DSSE envelope"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(
        ...,
        description="The value of the computed digest over the payload within the envelope",
    )


class DsseV001Schema1(BaseModel):
    """Schema for DSSE envelopes"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    proposed_content: ProposedContent = Field(..., alias="proposedContent")
    signatures: Optional[List[Signature]] = Field(
        default=None,
        description="extracted collection of all signatures of the envelope's payload; elements will be sorted by lexicographical order of the base64 encoded signature strings",
        min_length=1,
    )
    envelope_hash: Optional[EnvelopeHash] = Field(
        default=None,
        alias="envelopeHash",
        description="Specifies the hash algorithm and value encompassing the entire envelope sent to Rekor",
    )
    payload_hash: Optional[PayloadHash] = Field(
        default=None,
        alias="payloadHash",
        description="Specifies the hash algorithm and value covering the payload within the DSSE envelope",
    )


class EnvelopeHash1(EnvelopeHash):
    """Specifies the hash algorithm and value encompassing the entire envelope sent to Rekor"""


class PayloadHash1(PayloadHash):
    """Specifies the hash algorithm and value covering the payload within the DSSE envelope"""


class DsseV001Schema2(BaseModel):
    """Schema for DSSE envelopes"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    proposed_content: Optional[ProposedContent] = Field(default=None, alias="proposedContent")
    signatures: List[Signature] = Field(
        ...,
        description="extracted collection of all signatures of the envelope's payload; elements will be sorted by lexicographical order of the base64 encoded signature strings",
        min_length=1,
    )
    envelope_hash: EnvelopeHash1 = Field(
        ...,
        alias="envelopeHash",
        description="Specifies the hash algorithm and value encompassing the entire envelope sent to Rekor",
    )
    payload_hash: PayloadHash1 = Field(
        ...,
        alias="payloadHash",
        description="Specifies the hash algorithm and value covering the payload within the DSSE envelope",
    )


class DsseSchema(RootModel[Union[DsseV001Schema1, DsseV001Schema2]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Union[DsseV001Schema1, DsseV001Schema2] = Field(
        ...,
        description="log entry schema for dsse envelopes",
        title="DSSE Schema",
    )
