# generated by datamodel-codegen:
#   filename:  helm_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class PublicKey(BaseModel):
    """The public key that can verify the package signature"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str = Field(
        ...,
        description="Specifies the content of the public key inline within the document",
    )


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"


class Hash(BaseModel):
    """Specifies the hash algorithm and value for the chart"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the chart")


class Signature(BaseModel):
    """Information about the included signature in the provenance file"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str = Field(
        ...,
        description="Specifies the signature embedded within the provenance file ",
    )


class Provenance(BaseModel):
    """The provenance entry associated with the signed Helm Chart"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    signature: Signature = Field(
        ...,
        description="Information about the included signature in the provenance file",
    )
    content: Optional[str] = Field(
        default=None,
        description="Specifies the content of the provenance file inline within the document",
    )


class Provenance1(BaseModel):
    """The provenance entry associated with the signed Helm Chart"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    signature: Optional[Signature] = Field(
        default=None,
        description="Information about the included signature in the provenance file",
    )
    content: str = Field(
        ...,
        description="Specifies the content of the provenance file inline within the document",
    )


class Chart(BaseModel):
    """Information about the Helm chart associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hash: Optional[Hash] = Field(
        default=None,
        description="Specifies the hash algorithm and value for the chart",
    )
    provenance: Union[Provenance, Provenance1] = Field(
        ...,
        description="The provenance entry associated with the signed Helm Chart",
    )


class HelmV001Schema(BaseModel):
    """Schema for Helm object"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    public_key: PublicKey = Field(
        ...,
        alias="publicKey",
        description="The public key that can verify the package signature",
    )
    chart: Chart = Field(
        ...,
        description="Information about the Helm chart associated with the entry",
    )


class HelmSchema(RootModel[HelmV001Schema]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: HelmV001Schema = Field(..., description="Schema for Helm objects", title="Helm Schema")
