# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

inherit cargo systemd

COMMIT="614e2e2b497f54054310571ed03733b408a1ecc1"
DESCRIPTION="Rust service that decrypts YouTube signatures and manages player information"
HOMEPAGE="https://github.com/iv-org/inv_sig_helper"
SRC_URI="
	https://github.com/iv-org/inv_sig_helper/archive/${COMMIT}.tar.gz -> ${P}.gh.tar.gz
	https://jroy.ca/dist/${P}-vendor.tar.xz
"
S="${WORKDIR}/${PN}-${COMMIT}"

LICENSE="AGPL-3"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD MIT Unicode-DFS-2016"
SLOT="0"
KEYWORDS="~amd64"

RDEPEND="dev-libs/openssl"

src_unpack() {
	cargo_src_unpack
	ln -s "${WORKDIR}/vendor/"* "${CARGO_HOME}/gentoo/" || die
}

src_install() {
	cargo_src_install
	systemd_dounit "${S}"/inv_sig_helper.service
	newinitd "${FILESDIR}"/inv_sig_helper.initd "${PN}"
}
